#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_InappropriateTransfusionRequestReport : BaseTest 
	{
		private DateTime _divisionNow;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();			
			_divisionNow = VbecsDateTime.GetDivisionCurrentDateTime();
		}

		[Test]
		public void GetReportData_Pass_1()
		{
			DataSet _ds = InappropriateTransfusionRequestReport.GetReportData( DateTime.Now.AddYears( -10 ), DateTime.Now.AddYears( 10 ) );

			Assert.IsNotNull( _ds );
		}

		[Test]
		public void GetReportData_Pass_2()
		{
			DataSet _testReportData = InappropriateTransfusionRequestReport.GetReportData( DateTime.Now, DateTime.Now.AddYears( -1 ) );

			Assert.AreEqual(0, _testReportData.Tables[ COMMON.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateSurgicalRequestsTableName ].Rows.Count, "1Rows.Count" );
			Assert.AreEqual(0, _testReportData.Tables[ COMMON.DatabaseConstants.InappropriateTransfusionRequestReportDataUnits.InappropriateNonSurgicalRequestsTableName ].Rows.Count, "2Rows.Count" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportData_Fail()
		{
		}

		[Test]
		public void GetReportCountEstimate_Pass_1()
		{			
			Assert.IsTrue( InappropriateTransfusionRequestReport.GetRecordCountEstimate( _divisionNow.AddYears( -100 ), _divisionNow ) >= 0 );
		}

		[Test]
		public void GetReportCountEstimate_Pass_2()
		{
			Assert.AreEqual( 0, InappropriateTransfusionRequestReport.GetRecordCountEstimate( _divisionNow.AddYears( 100 ), _divisionNow ) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportCountEstimate_Fail() 
		{
		}

	}
}
#endif
